package com.example.myapplication

import android.util.Log
import android.widget.ImageButton

class Squares(imagebutton: Array<Array<ImageButton>>) {
    val square: MutableList<MutableList<Square>> = mutableListOf()

    var houkou = arrayOf(
        arrayOf(arrayOf(-1,-1),arrayOf(1,1)),
        arrayOf(arrayOf(-1,0),arrayOf(1,0)),
        arrayOf(arrayOf(-1,1),arrayOf(1,-1)),
        arrayOf(arrayOf(0,-1),arrayOf(0,1))
    )
    init{
        imagebutton.forEachIndexed { idx1, element ->
            var list: MutableList<Square> = mutableListOf()
            element.forEachIndexed{idx2,element2->
                list.add(Square(0,imagebutton[idx1][idx2]))
            }
            square.add(list)
        }
    }
    fun stg(next:Boolean=false,level:Double,ban:Int,narabe:Int): SerchResult? {
        if(level>Const.FUKASA[ban] ) {
            return null
        }
        val list: MutableList<SerchResult> = mutableListOf()
        for(idx1 in 0 until ban) {                              //全てのマス目を捜査する
            for (idx2 in 0 until ban) {
                //手が打たれている、周りが空白なら走査しない
                if(checkAround(idx1,idx2,ban)==false){
                    continue
                }
                var score = search(idx1,idx2,next,ban,narabe)   //仮に手を打ち、評価する
                score = score / level                           //評価値をレベルに合わせ調整
                var serchresult:SerchResult?
                serchresult = SerchResult(idx2, idx1, score, next)
                if(score == 0.0 ) {                             //勝ち負けがつかないなら、深いレベルを走査
                    var serchresult2 = stg(!next, level + 1, ban, narabe) //再帰処理
                    if (serchresult2 != null) {
                        serchresult.score = serchresult2!!.score
                    }
                }
                list.add(serchresult)                           //評価情報を格納する
                square[idx1][idx2].state = Const.KUHAKU         //仮に打った手を空白に戻す
            }
        }
        list.sortWith(Comparator {                              //評価情報をソートする
                a,b ->  a.score.compareTo(b.score)
        })

        if( list.isEmpty()){
            return   null
        }else {
            //相手番なら一番低い評価、コンピュータ番なら高い評価を選択
            var ret = if (next) list.get(0) else list.get(list.size - 1)
            //評価値が全て同じなら、ランダムに手を決定する。
            if(list.get(0).score == list.get(list.size - 1).score){
                var r = (0..list.size-1).random()
                return list.get(r)
            }else{
                return ret
            }
        }
    }
    //仮に手を打ち、評価する
    fun search(x:Int,y:Int,next:Boolean,ban:Int,narabe:Int):Double{
        square[x][y].state= if (next) Const.BATU else Const.MARU

        var ret = jug(x,y,ban,narabe)
        if(ret != Const.KUHAKU && ret != Const.DRAW){
            //勝ちが決定なら、相手番なら-100、コンピュータ番なら100
            return if(next) -100.0 else 100.0
        }
        return 0.0
    }
    fun checkAround(x:Int,y:Int,ban:Int):Boolean{
        if(square[x][y].state != Const.KUHAKU){
            return false
        }

        var x2 = x - 1
        var x3 = x + 1
        var y2 = y - 1
        var y3 = y + 1
        if(x2 < 0) x2 = 0
        if(x3 >= ban) x3 = ban -1
        if(y2 < 0 ) y2 = 0
        if(y3 >=ban)y3 = ban -1
        var flg = false
        exit@  for(y4 in y2..y3){
            for(x4 in x2..x3){
                if(x == x4 && y == y4) continue
                if(square[x4][y4].state != Const.KUHAKU){
                    flg = true
                    break@exit
                }
            }
        }
        return flg
    }
    fun isKUHAKU(x:Int,y:Int):Boolean{
        return if(square[x][y].state == Const.KUHAKU) true else false
    }
    fun click(x:Int,y:Int,next:Boolean) {
        var ne= if(next) Const.BATU else Const.MARU
        square[x][y].click(ne)
    }
    fun jug(x:Int,y:Int,ban:Int,narabe:Int):Int {  //戻り値 0:勝負つかず、1:✕勝利、2:〇勝利、3:マス目が埋まっている
        //Log.d("Squares","ban="+ban+" narabe="+narabe)
        var isFinal = true                          //マス目が全て埋まっているかフラグ

        for (h1 in houkou.indices) {                   //八方を探索
            var count = 1
            for (h2 in houkou[h1].indices) {
                var x2 = x
                var y2 = y
                while (true) {                            //マス目をはみ出すまで永久ループ
                    x2 = x2 + houkou[h1][h2][0]               //x,y座標を増減し探索
                    y2 = y2 + houkou[h1][h2][1]                //
                    if (x2 >= ban || x2 < 0) {                //横軸はみ出ている？
                        break
                    }
                    if (y2 >= ban || y2 < 0) {                //縦軸はみ出ている？
                        break
                    }
                    if (square[x2][y2].state == Const.KUHAKU ) {
                        break
                    }
                    if (square[x2][y2].state == Const.KUHAKU || square[x][y].state != square[x2][y2].state) {
                        break
                    }
                    count++
                }
                if (count >= narabe) {                         //マークが3つ以上並んだか？
                    return square[x][y].state
                }
            }
        }
        return Const.KUHAKU
    }

    fun allClear() {
        for (idx1 in square.indices) {
            for (idx2 in square[idx1].indices) {
                square[idx1][idx2].click(Const.KUHAKU)
            }
        }
    }
}